/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.jdm;

import ibm.nways.jdm.BrowserApplet;
import ibm.nways.jdm.CheckConfigThread;
import ibm.nways.jdm.CompStatExplain;
import ibm.nways.jdm.FolderRow;
import ibm.nways.jdm.HasJmaPopup;
import ibm.nways.jdm.HasStatusDependents;
import ibm.nways.jdm.ItemRow;
import ibm.nways.jdm.LockedMlTree;
import ibm.nways.jdm.NavigationBrowserEventListener;
import ibm.nways.jdm.NavigationDestination;
import ibm.nways.jdm.NavigationFolder;
import ibm.nways.jdm.NavigationFolderListener;
import ibm.nways.jdm.NavigationPoint;
import ibm.nways.jdm.RemoteModel;
import ibm.nways.jdm.Status;
import ibm.nways.jdm.StatusExplain;
import ibm.nways.jdm.TreeRow;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Insets;
import java.awt.Menu;
import java.awt.MenuItem;
import java.awt.Panel;
import java.awt.PopupMenu;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Enumeration;
import java.util.ResourceBundle;
import java.util.Vector;
import mlsoft.mct.MlResources;
import mlsoft.mct.MlTree;
import mlsoft.mct.MlTreeEvent;
import mlsoft.mct.MlTreeListener;

public class NavigationBrowser
extends Panel
implements MlTreeListener,
MouseListener,
NavigationFolderListener,
HasJmaPopup {
    private BrowserApplet browserApplet;
    private NavigationPoint navTop;
    private MlTree tree;
    private Vector treeRows;
    private Vector eventListeners;
    private static Object expansionLock = new Object();
    private PopupMenu popup;
    private boolean popupEnabled = true;
    private Menu statusMenu;
    private Menu configMenu;
    private MenuItem checkConfigMenuItem;
    private static final String BlankBgroundParm = "tree.blankBackgroundColor";
    private static final String BotShadParm = "tree.bottomShadowColor";
    private static final String TopShadParm = "tree.topShadowColor";
    private static final String LineParm = "tree.connectingLineColor";
    private static final String PlusMinusParm = "tree.plusMinusColor";
    private static final String SelectForeParm = "tree.selectForeground";
    private static final String SelectBackParm = "tree.selectBackground";
    public static final String StatusMenuName = "NavigationBrowserStatusMenu";
    public static final String ConfigMenuName = "NavigationBrowserConfigMenu";
    protected static ResourceBundle myResources = null;

    public NavigationBrowser(NavigationPoint navigationPoint, BrowserApplet browserApplet, NavigationBrowserEventListener navigationBrowserEventListener) {
        this.browserApplet = browserApplet;
        this.browserApplet.displayMsg(NavigationBrowser.messageText("InitializingMsg"));
        Color color = browserApplet.getBackground();
        Color color2 = browserApplet.getForeground();
        this.browserApplet.displayMsg(NavigationBrowser.messageText("ConfigEnvironmentMsg"));
        ItemRow.initImages(browserApplet);
        FolderRow.initImages(browserApplet);
        this.navTop = navigationPoint;
        this.eventListeners = new Vector();
        this.eventListeners.addElement(navigationBrowserEventListener);
        this.tree = new LockedMlTree();
        this.tree.enable(new Ml31Key());
        MlResources mlResources = new MlResources();
        mlResources.add("verticalSizePolicy", 1);
        mlResources.add("horizontalSizePolicy", 1);
        mlResources.add("cellDefaults", true);
        mlResources.add("cellBackground", color);
        mlResources.add("connectingLineColor", browserApplet.getColorForParm(LineParm, new Color(0x464646)));
        mlResources.add("plusMinusColor", browserApplet.getColorForParm(PlusMinusParm, new Color(0)));
        mlResources.add("selectForeground", browserApplet.getColorForParm(SelectForeParm, new Color(0xFFFFFF)));
        mlResources.add("selectBackground", browserApplet.getColorForParm(SelectBackParm, new Color(120)));
        mlResources.add("cellForeground", color2);
        this.tree.setValues(mlResources);
        this.tree.setLayoutFrozen(true);
        this.tree.setBlankBackground(browserApplet.getColorForParm(BlankBgroundParm, color));
        this.tree.setBottomShadowColor(browserApplet.getColorForParm(BotShadParm, color));
        this.tree.setTopShadowColor(browserApplet.getColorForParm(TopShadParm, color));
        this.tree.addMlTreeListener(this);
        this.treeRows = new Vector();
        this.browserApplet.displayMsg(NavigationBrowser.messageText("DetermineDeviceMsg"));
        this.populateBrowser(1, this.navTop, -1);
        this.setLayout(new BorderLayout());
        this.add("Center", this.tree);
        this.tree.setSelectionPolicy(1);
        this.tree.setLayoutFrozen(false);
        if (navigationPoint instanceof NavigationFolder) {
            ((NavigationFolder)navigationPoint).addListener(this);
            this.browserApplet.displayMsg(NavigationBrowser.messageText("CompleteMsg"));
        }
        this.tree.addMouseListener(this);
        this.popup = this.getNewPopupMenu();
        browserApplet.getParent().add(this.popup);
        this.statusMenu = (Menu)this.getMenuItemNamed(this.popup, StatusMenuName);
        this.configMenu = (Menu)this.getMenuItemNamed(this.popup, ConfigMenuName);
    }

    public PopupMenu getNewPopupMenu() {
        PopupMenu popupMenu = this.browserApplet.getNewPopupMenu();
        popupMenu.addSeparator();
        Menu menu = new Menu(NavigationBrowser.messageText("Status"));
        menu.setName(StatusMenuName);
        popupMenu.add(menu);
        MenuItem menuItem = new MenuItem(NavigationBrowser.messageText("ExplainStatus"));
        menuItem.addActionListener(new ExplainStatusAdapter());
        menu.add(menuItem);
        menuItem = new MenuItem(NavigationBrowser.messageText("CheckStatus"));
        menuItem.addActionListener(new CheckStatusAdapter());
        menu.add(menuItem);
        menu = new Menu(NavigationBrowser.messageText("Configuration"));
        menu.setName(ConfigMenuName);
        popupMenu.add(menu);
        this.checkConfigMenuItem = new MenuItem(NavigationBrowser.messageText("Check Configuration"));
        this.checkConfigMenuItem.addActionListener(new CheckConfigChange());
        menu.add(this.checkConfigMenuItem);
        menuItem = new MenuItem(NavigationBrowser.messageText("Redraw Configuration"));
        menuItem.addActionListener(new RedrawConfiguration());
        menu.add(menuItem);
        return popupMenu;
    }

    public void setPopupEnabled(boolean bl) {
        this.popupEnabled = bl;
    }

    public void addEventListener(NavigationBrowserEventListener navigationBrowserEventListener) {
        if (!this.eventListeners.contains(navigationBrowserEventListener)) {
            this.eventListeners.addElement(navigationBrowserEventListener);
        }
    }

    public void removeEventListener(NavigationBrowserEventListener navigationBrowserEventListener) {
        if (this.eventListeners.contains(navigationBrowserEventListener)) {
            this.eventListeners.removeElement(navigationBrowserEventListener);
        }
    }

    public Insets getInsets() {
        return new Insets(5, 5, 5, 5);
    }

    private void fixupSize() {
        Object object = this.getTreeLock();
        synchronized (object) {
            this.invalidate();
            this.browserApplet.invalidate();
            this.browserApplet.validate();
            return;
        }
    }

    private void populateBrowser(int n, NavigationPoint navigationPoint, int n2) {
        int n3 = n2;
        if (n3 < 0) {
            n3 = this.treeRows.size();
        }
        if (navigationPoint instanceof NavigationFolder) {
            FolderRow folderRow = new FolderRow(this.tree, navigationPoint);
            this.treeRows.insertElementAt(folderRow, n3);
            NavigationFolder navigationFolder = (NavigationFolder)navigationPoint;
            this.tree.addRow(n, true, navigationFolder.getIsInitiallyExpanded(), n2, folderRow.getImage(), navigationPoint.getLabel());
            Enumeration enumeration = navigationFolder.getContents();
            while (enumeration.hasMoreElements()) {
                NavigationPoint navigationPoint2 = (NavigationPoint)enumeration.nextElement();
                if (n2 >= 0) {
                    ++n2;
                }
                this.populateBrowser(n + 1, navigationPoint2, n2);
            }
            return;
        }
        ItemRow itemRow = new ItemRow(this.tree, navigationPoint);
        this.treeRows.insertElementAt(itemRow, n3);
        this.tree.addRow(n, false, false, n2, itemRow.getImage(), navigationPoint.getLabel());
    }

    public boolean addNavigationFolderChild(NavigationFolder navigationFolder, NavigationPoint navigationPoint) {
        Object object = this.getTreeLock();
        synchronized (object) {
            int n = this.rowForPoint(navigationFolder);
            if (n < 0) {
                boolean bl = false;
                Object var5_7 = null;
                return bl;
            }
            int n2 = (Integer)this.tree.getRowValue(n, "rowLevel");
            int n3 = -1;
            int n4 = n + 1;
            while (n4 < this.treeRows.size()) {
                int n5 = (Integer)this.tree.getRowValue(n4, "rowLevel");
                if (n5 <= n2) {
                    n3 = n4;
                    break;
                }
                ++n4;
            }
            this.populateBrowser(n2 + 1, navigationPoint, n3);
            this.fixupSize();
            boolean bl = true;
            Object var5_8 = null;
            return bl;
        }
    }

    public boolean removeNavigationFolderChild(NavigationFolder navigationFolder, NavigationPoint navigationPoint) {
        Object object = this.getTreeLock();
        synchronized (object) {
            int n;
            int n2 = this.rowForPoint(navigationPoint);
            if (n2 < 0) {
                boolean bl = false;
                Object var5_7 = null;
                return bl;
            }
            int n3 = (Integer)this.tree.getRowValue(n2, "rowLevel");
            do {
                this.tree.deleteRows(1, n2, 1);
                this.treeRows.removeElementAt(n2);
            } while ((n = ((Integer)this.tree.getRowValue(n2, "rowLevel")).intValue()) > n3);
            boolean bl = true;
            Object var5_8 = null;
            return bl;
        }
    }

    public void setIsExpanded(NavigationFolder navigationFolder, boolean bl) {
        Object object = this.getTreeLock();
        synchronized (object) {
            int n = this.rowForPoint(navigationFolder);
            if (n < 0) {
                Object var4_5 = null;
                return;
            }
            MlResources mlResources = new MlResources();
            mlResources.add("row", n);
            mlResources.add("rowIsExpanded", bl);
            this.tree.setValues(mlResources);
            return;
        }
    }

    private int rowForPoint(NavigationPoint navigationPoint) {
        int n = this.treeRows.size() - 1;
        while (n >= 0) {
            TreeRow treeRow = (TreeRow)this.treeRows.elementAt(n);
            if (treeRow.navPoint == navigationPoint) {
                return n;
            }
            --n;
        }
        return -1;
    }

    public void deselectAll() {
        this.tree.deselectAllRows(false);
    }

    public void onTreeEvent(MlTreeEvent mlTreeEvent) {
        DoTreeEventThread doTreeEventThread = new DoTreeEventThread(mlTreeEvent);
        doTreeEventThread.start();
    }

    public void doTreeEvent(MlTreeEvent mlTreeEvent) {
        if (mlTreeEvent.getType() == 5016) {
            int n = mlTreeEvent.row;
            TreeRow treeRow = (TreeRow)this.treeRows.elementAt(n);
            Enumeration enumeration = this.eventListeners.elements();
            while (enumeration.hasMoreElements()) {
                ((NavigationBrowserEventListener)enumeration.nextElement()).navPointSelected(treeRow.navPoint);
            }
            return;
        }
        if (mlTreeEvent.getType() == 5020) {
            int n = mlTreeEvent.row;
            FolderRow folderRow = (FolderRow)this.treeRows.elementAt(n);
            folderRow.openFolder();
            folderRow.update();
            Object object = expansionLock;
            synchronized (object) {
                this.setCursor(new Cursor(3));
                Enumeration enumeration = this.eventListeners.elements();
                while (enumeration.hasMoreElements()) {
                    ((NavigationBrowserEventListener)enumeration.nextElement()).navigationFolderExpanded((NavigationFolder)folderRow.navPoint);
                }
                this.setCursor(new Cursor(0));
            }
            this.fixupSize();
            return;
        }
        if (mlTreeEvent.getType() == 5019) {
            int n = mlTreeEvent.row;
            FolderRow folderRow = (FolderRow)this.treeRows.elementAt(n);
            folderRow.closeFolder();
            folderRow.update();
            Enumeration enumeration = this.eventListeners.elements();
            while (enumeration.hasMoreElements()) {
                ((NavigationBrowserEventListener)enumeration.nextElement()).navigationFolderCollapsed((NavigationFolder)folderRow.navPoint);
            }
        }
    }

    protected static String messageText(String string) {
        try {
            if (myResources == null) {
                myResources = ResourceBundle.getBundle("ibm.nways.jdm.NavigationBrowserResources");
            }
            if (myResources == null) {
                return string;
            }
            return myResources.getString(string);
        }
        catch (Exception exception) {
            return string;
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (this.popupEnabled) {
            this.checkPopup(mouseEvent);
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.popupEnabled) {
            this.checkPopup(mouseEvent);
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    private void checkPopup(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            int n = this.tree.getSelectedRow();
            if (n == -1) {
                this.statusMenu.setEnabled(false);
                this.checkConfigMenuItem.setEnabled(false);
            } else {
                TreeRow treeRow = (TreeRow)this.treeRows.elementAt(n);
                if (treeRow.navPoint.getStatus() == null) {
                    this.statusMenu.setEnabled(false);
                } else {
                    this.statusMenu.setEnabled(true);
                }
                boolean bl = false;
                NavigationDestination navigationDestination = treeRow.navPoint.getDestination();
                if (navigationDestination != null && navigationDestination.getModel() != null) {
                    bl = true;
                }
                this.checkConfigMenuItem.setEnabled(bl);
            }
            this.popup.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
        }
    }

    private void explainStatusAction() {
        int n = this.tree.getSelectedRow();
        if (n == -1) {
            System.out.println("Nothing selected!!");
            return;
        }
        TreeRow treeRow = (TreeRow)this.treeRows.elementAt(n);
        Status status = treeRow.navPoint.getStatus();
        if (status == null) {
            System.out.println("No status!!");
            return;
        }
        if (status instanceof HasStatusDependents) {
            CompStatExplain compStatExplain = new CompStatExplain(this.browserApplet, status);
            compStatExplain.show();
            return;
        }
        StatusExplain statusExplain = new StatusExplain(this.browserApplet, status);
        statusExplain.show();
    }

    private MenuItem getMenuItemNamed(Menu menu, String string) {
        MenuItem menuItem = null;
        int n = menu.getItemCount() - 1;
        while (n >= 0) {
            MenuItem menuItem2 = menu.getItem(n);
            if (menuItem2.getName().equals(string)) {
                menuItem = menuItem2;
                break;
            }
            --n;
        }
        return menuItem;
    }

    private void checkStatusAction() {
        int n = this.tree.getSelectedRow();
        if (n == -1) {
            System.out.println("Nothing selected!!");
            return;
        }
        TreeRow treeRow = (TreeRow)this.treeRows.elementAt(n);
        Status status = treeRow.navPoint.getStatus();
        if (status == null) {
            System.out.println("No status!!");
            return;
        }
        this.browserApplet.displayMsg(NavigationBrowser.messageText("CheckingStatusMsg"));
        status.check();
        this.browserApplet.displayMsg(NavigationBrowser.messageText("CheckingStatusDoneMsg"));
    }

    private void checkConfigAction() {
        RemoteModel remoteModel = null;
        int n = this.tree.getSelectedRow();
        if (n == -1) {
            return;
        }
        TreeRow treeRow = (TreeRow)this.treeRows.elementAt(n);
        NavigationDestination navigationDestination = treeRow.navPoint.getDestination();
        if (navigationDestination != null) {
            remoteModel = navigationDestination.getModel();
        }
        if (remoteModel != null) {
            CheckConfigThread checkConfigThread = new CheckConfigThread(remoteModel, this.browserApplet, NavigationBrowser.messageText("CheckingConfigMsg"), NavigationBrowser.messageText("CheckingConfigDoneMsg"));
            checkConfigThread.start();
        }
    }

    private void redrawConfigAction() {
        RedrawConfigActionThread redrawConfigActionThread = new RedrawConfigActionThread();
        redrawConfigActionThread.start();
    }

    private BrowserApplet getBrowserApplet() {
        return this.browserApplet;
    }

    final /* synthetic */ void access$0() {
        this.checkStatusAction();
    }

    final /* synthetic */ void access$1() {
        this.checkConfigAction();
    }

    final /* synthetic */ void access$2() {
        this.redrawConfigAction();
    }

    final /* synthetic */ BrowserApplet access$3() {
        return this.getBrowserApplet();
    }

    final /* synthetic */ void access$4() {
        this.explainStatusAction();
    }

    class ExplainStatusAdapter
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            NavigationBrowser.this.access$4();
        }

        ExplainStatusAdapter() {
            NavigationBrowser.this = NavigationBrowser.this;
        }
    }

    class CheckStatusAdapter
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            NavigationBrowser.this.access$0();
        }

        CheckStatusAdapter() {
            NavigationBrowser.this = NavigationBrowser.this;
        }
    }

    class CheckConfigChange
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            NavigationBrowser.this.access$1();
        }

        CheckConfigChange() {
            NavigationBrowser.this = NavigationBrowser.this;
        }
    }

    class RedrawConfiguration
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            NavigationBrowser.this.access$2();
        }

        RedrawConfiguration() {
            NavigationBrowser.this = NavigationBrowser.this;
        }
    }

    class DoTreeEventThread
    extends Thread {
        MlTreeEvent event;

        public DoTreeEventThread(MlTreeEvent mlTreeEvent) {
            NavigationBrowser.this = NavigationBrowser.this;
            this.event = mlTreeEvent;
        }

        public void run() {
            NavigationBrowser.this.doTreeEvent(this.event);
        }
    }

    class RedrawConfigActionThread
    extends Thread {
        public void run() {
            NavigationBrowser.this.access$3().refreshAll();
        }

        RedrawConfigActionThread() {
            NavigationBrowser.this = NavigationBrowser.this;
        }
    }
}

